#include "CPyramid.h"
#include <iostream>
#include <cmath>

using namespace std;

CPyramid::CPyramid(float size, float pHeight) {
    num_vertices = 5;
    vertices = new float[num_vertices][3];
    baseSize = size;
    height = pHeight;
    float halfBaseSize = baseSize/2.0;
    float halfHeight = height/2.0;
    //Pyramide soll ihren Mittelpunkt (Mittelpunkt der Hoehe h) im Ursprung
    //haben
    //Grundflaeche liegt parallel zur XZ-Ebene
    vertices[0][0] = -halfBaseSize;
    vertices[0][1] = -halfHeight;
    vertices[0][2] = halfBaseSize;

    vertices[1][0] = -halfBaseSize;
    vertices[1][1] = -halfHeight;
    vertices[1][2] = -halfBaseSize;

    vertices[2][0] = halfBaseSize;
    vertices[2][1] = -halfHeight;
    vertices[2][2] = -halfBaseSize;

    vertices[3][0] = halfBaseSize;
    vertices[3][1] = -halfHeight;
    vertices[3][2] = halfBaseSize;
    //Spitze der Pyramide liegt somit auf der y-Achse
    vertices[4][0] = 0;
    vertices[4][1] = halfHeight;
    vertices[4][2] = 0;
}

CPyramid::~CPyramid() {
    delete[] vertices;
}

    void CPyramid::print() {
        for(int i = 0; i < num_vertices; i++) {
            for(int j = 0; j < 3; j++) {
                cout << vertices[i][j] << endl;
            }
            cout << endl;
        }
        cout << "Base size: " << baseSize << endl;
        cout << "Height: " << height << endl;
        cout << "Surface area: " << getSurfaceArea() << endl;
        cout << "Volume: " << getVolume() << endl;
    }

    float CPyramid::getSurfaceArea() {
        float baseArea = baseSize * baseSize;
        float lateralArea = baseSize * sqrt(4.0 * height * height + baseSize * baseSize);

        return baseArea + lateralArea;
    }

    float CPyramid::getVolume() {
        return 1.0/3 * baseSize * baseSize * height;
    }

